<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

// Teklif formu sayfası
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Teklif Formu - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Inter:wght@300;400;500;600;700&display=swap" rel="stylesheet">
    <style>
        :root {
            --primary-blue: #2563eb;
            --secondary-blue: #3b82f6;
            --light-blue: #dbeafe;
            --dark-blue: #1e40af;
            --pure-white: #ffffff;
            --light-gray: #f8fafc;
            --medium-gray: #64748b;
            --dark-gray: #334155;
            --gradient-primary: linear-gradient(135deg, #2563eb 0%, #3b82f6 100%);
            --gradient-light: linear-gradient(135deg, #f8fafc 0%, #e2e8f0 100%);
            --shadow-sm: 0 1px 2px 0 rgb(0 0 0 / 0.05);
            --shadow-md: 0 4px 6px -1px rgb(0 0 0 / 0.1), 0 2px 4px -2px rgb(0 0 0 / 0.1);
            --shadow-lg: 0 10px 15px -3px rgb(0 0 0 / 0.1), 0 4px 6px -4px rgb(0 0 0 / 0.1);
            --shadow-xl: 0 20px 25px -5px rgb(0 0 0 / 0.1), 0 8px 10px -6px rgb(0 0 0 / 0.1);
        }

        * {
            margin: 0;
            padding: 0;
            box-sizing: border-box;
        }

        body {
            font-family: 'Inter', sans-serif;
            line-height: 1.6;
            color: var(--dark-gray);
            background: var(--gradient-light);
            min-height: 100vh;
        }

        /* Modern Navigation */
        .modern-navbar {
            background: var(--pure-white);
            box-shadow: var(--shadow-md);
            padding: 1rem 0;
        }

        .navbar-brand {
            font-family: 'Poppins', sans-serif;
            font-weight: 700;
            font-size: 1.5rem;
            color: var(--primary-blue) !important;
            text-decoration: none;
        }

        .nav-link {
            color: var(--medium-gray) !important;
            font-weight: 500;
            text-decoration: none;
            transition: color 0.3s ease;
        }

        .nav-link:hover {
            color: var(--primary-blue) !important;
        }

        /* Form Container */
        .form-container {
            max-width: 800px;
            margin: 2rem auto;
            padding: 0 1rem;
        }

        .form-card {
            background: var(--pure-white);
            border-radius: 20px;
            box-shadow: var(--shadow-xl);
            overflow: hidden;
            border: 1px solid rgba(37, 99, 235, 0.1);
        }

        .form-header {
            background: var(--gradient-primary);
            color: white;
            padding: 2rem;
            text-align: center;
        }

        .form-title {
            font-family: 'Poppins', sans-serif;
            font-size: 2rem;
            font-weight: 700;
            margin-bottom: 0.5rem;
        }

        .form-subtitle {
            font-size: 1rem;
            opacity: 0.9;
        }

        .form-body {
            padding: 2rem;
        }

        /* Progress Steps */
        .progress-steps {
            display: flex;
            justify-content: center;
            margin-bottom: 2rem;
            padding: 0 1rem;
        }

        .step {
            display: flex;
            align-items: center;
            flex: 1;
            max-width: 200px;
        }

        .step-number {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: var(--light-gray);
            color: var(--medium-gray);
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: 600;
            margin-right: 0.75rem;
            transition: all 0.3s ease;
        }

        .step.active .step-number {
            background: var(--primary-blue);
            color: white;
        }

        .step.completed .step-number {
            background: #10b981;
            color: white;
        }

        .step-title {
            font-weight: 500;
            color: var(--medium-gray);
            font-size: 0.875rem;
        }

        .step.active .step-title {
            color: var(--primary-blue);
            font-weight: 600;
        }

        .step.completed .step-title {
            color: #10b981;
            font-weight: 600;
        }

        .step-connector {
            flex: 1;
            height: 2px;
            background: var(--light-gray);
            margin: 0 1rem;
        }

        .step.completed + .step .step-connector {
            background: #10b981;
        }

        /* Form Sections */
        .form-section {
            display: none;
        }

        .form-section.active {
            display: block;
            animation: fadeInUp 0.5s ease;
        }

        .section-title {
            font-family: 'Poppins', sans-serif;
            font-size: 1.5rem;
            font-weight: 600;
            color: var(--dark-blue);
            margin-bottom: 1.5rem;
            text-align: center;
        }

        /* Form Controls */
        .modern-form-group {
            margin-bottom: 1.5rem;
        }

        .modern-form-label {
            display: block;
            font-weight: 500;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }

        .modern-form-control {
            width: 100%;
            padding: 0.875rem 1rem;
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            font-size: 1rem;
            transition: all 0.3s ease;
            background: var(--pure-white);
        }

        .modern-form-control:focus {
            outline: none;
            border-color: var(--primary-blue);
            box-shadow: 0 0 0 3px rgba(37, 99, 235, 0.1);
        }

        .modern-form-control.is-invalid {
            border-color: #ef4444;
        }

        .modern-form-control.is-valid {
            border-color: #10b981;
        }

        .invalid-feedback {
            color: #ef4444;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        .valid-feedback {
            color: #10b981;
            font-size: 0.875rem;
            margin-top: 0.25rem;
        }

        /* Buttons */
        .modern-btn {
            background: var(--gradient-primary);
            color: white;
            border: none;
            padding: 0.875rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            box-shadow: var(--shadow-md);
            cursor: pointer;
        }

        .modern-btn:hover {
            transform: translateY(-2px);
            box-shadow: var(--shadow-lg);
            color: white;
        }

        .modern-btn:disabled {
            opacity: 0.6;
            cursor: not-allowed;
            transform: none;
        }

        .modern-btn-outline {
            background: transparent;
            color: var(--primary-blue);
            border: 2px solid var(--primary-blue);
            padding: 0.875rem 2rem;
            border-radius: 12px;
            font-weight: 600;
            text-decoration: none;
            display: inline-flex;
            align-items: center;
            gap: 0.5rem;
            transition: all 0.3s ease;
            cursor: pointer;
        }

        .modern-btn-outline:hover {
            background: var(--primary-blue);
            color: white;
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        /* Form Navigation */
        .form-navigation {
            display: flex;
            justify-content: space-between;
            align-items: center;
            margin-top: 2rem;
            padding-top: 2rem;
            border-top: 1px solid #e2e8f0;
        }

        /* Service Type Cards */
        .service-cards {
            display: grid;
            grid-template-columns: repeat(auto-fit, minmax(200px, 1fr));
            gap: 1rem;
            margin-bottom: 1.5rem;
        }

        .service-card {
            background: var(--pure-white);
            border: 2px solid #e2e8f0;
            border-radius: 12px;
            padding: 1.5rem;
            text-align: center;
            cursor: pointer;
            transition: all 0.3s ease;
        }

        .service-card:hover {
            border-color: var(--primary-blue);
            transform: translateY(-2px);
            box-shadow: var(--shadow-md);
        }

        .service-card.selected {
            border-color: var(--primary-blue);
            background: var(--light-blue);
        }

        .service-icon {
            font-size: 2rem;
            color: var(--primary-blue);
            margin-bottom: 0.75rem;
        }

        .service-title {
            font-weight: 600;
            color: var(--dark-gray);
            margin-bottom: 0.5rem;
        }

        .service-description {
            font-size: 0.875rem;
            color: var(--medium-gray);
        }

        /* Animations */
        @keyframes fadeInUp {
            from {
                opacity: 0;
                transform: translateY(20px);
            }
            to {
                opacity: 1;
                transform: translateY(0);
            }
        }

        /* Loading Spinner */
        .loading-spinner {
            display: none;
            width: 20px;
            height: 20px;
            border: 2px solid rgba(255, 255, 255, 0.3);
            border-radius: 50%;
            border-top-color: white;
            animation: spin 1s ease-in-out infinite;
        }

        @keyframes spin {
            to { transform: rotate(360deg); }
        }

        /* Responsive Design */
        @media (max-width: 768px) {
            .form-container {
                margin: 1rem auto;
                padding: 0 0.5rem;
            }

            .form-body {
                padding: 1.5rem;
            }

            .progress-steps {
                flex-direction: column;
                gap: 1rem;
            }

            .step {
                max-width: none;
            }

            .step-connector {
                display: none;
            }

            .form-navigation {
                flex-direction: column;
                gap: 1rem;
            }

            .service-cards {
                grid-template-columns: 1fr;
            }
        }
    </style>
</head>
<body>
    <!-- Modern Navigation -->
    <nav class="navbar modern-navbar">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car me-2"></i>
                Araç Bakım Servisi
            </a>
            <div class="navbar-nav">
                <a class="nav-link" href="index.php">
                    <i class="fas fa-arrow-left me-2"></i>Ana Sayfa
                </a>
            </div>
        </div>
    </nav>

    <div class="form-container">
        <div class="form-card">
            <div class="form-header">
                <h1 class="form-title">Teklif Formu</h1>
                <p class="form-subtitle">Aracınız için ücretsiz teklif almak üzere formu doldurun</p>
            </div>

            <div class="form-body">
                <!-- Progress Steps -->
                <div class="progress-steps">
                    <div class="step active" id="step1">
                        <div class="step-number">1</div>
                        <div class="step-title">Kişisel Bilgiler</div>
                    </div>
                    <div class="step-connector"></div>
                    <div class="step" id="step2">
                        <div class="step-number">2</div>
                        <div class="step-title">Araç Bilgileri</div>
                    </div>
                    <div class="step-connector"></div>
                    <div class="step" id="step3">
                        <div class="step-number">3</div>
                        <div class="step-title">Hizmet Detayları</div>
                    </div>
                </div>

                <form id="quoteForm" method="POST" action="process_quote.php">
                    <!-- Step 1: Kişisel Bilgiler -->
                    <div class="form-section active" id="section1">
                        <h3 class="section-title">Kişisel Bilgileriniz</h3>
                        
                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="first_name">Ad *</label>
                                    <input type="text" class="modern-form-control" id="first_name" name="first_name" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="last_name">Soyad *</label>
                                    <input type="text" class="modern-form-control" id="last_name" name="last_name" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="phone">Telefon *</label>
                                    <input type="tel" class="modern-form-control" id="phone" name="phone" required>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="email">E-posta</label>
                                    <input type="email" class="modern-form-control" id="email" name="email">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="modern-form-group">
                            <label class="modern-form-label" for="address">Adres</label>
                            <textarea class="modern-form-control" id="address" name="address" rows="3" placeholder="İletişim adresinizi yazın..."></textarea>
                        </div>
                    </div>

                    <!-- Step 2: Araç Bilgileri -->
                    <div class="form-section" id="section2">
                        <h3 class="section-title">Araç Bilgileri</h3>
                        
                        <div class="row">
                            <div class="col-md-4">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="brand">Marka *</label>
                                    <input type="text" class="modern-form-control" id="brand" name="brand" required placeholder="Örn: Toyota">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="model">Model *</label>
                                    <input type="text" class="modern-form-control" id="model" name="model" required placeholder="Örn: Corolla">
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                            <div class="col-md-4">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="year">Model Yılı *</label>
                                    <select class="modern-form-control" id="year" name="year" required>
                                        <option value="">Model Yılını Seçin</option>
                                        <?php for($y = 2024; $y >= 1990; $y--): ?>
                                            <option value="<?= $y ?>"><?= $y ?></option>
                                        <?php endfor; ?>
                                    </select>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="fuel_type">Yakıt Türü</label>
                                    <select class="modern-form-control" id="fuel_type" name="fuel_type">
                                        <option value="">Seçiniz</option>
                                        <option value="benzin">Benzin</option>
                                        <option value="dizel">Dizel</option>
                                        <option value="lpg">LPG</option>
                                        <option value="hibrit">Hibrit</option>
                                        <option value="elektrik">Elektrik</option>
                                    </select>
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="transmission">Vites Türü</label>
                                    <select class="modern-form-control" id="transmission" name="transmission">
                                        <option value="">Seçiniz</option>
                                        <option value="manuel">Manuel</option>
                                        <option value="otomatik">Otomatik</option>
                                        <option value="yarimotomatik">Yarı Otomatik</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="plate">Plaka</label>
                                    <input type="text" class="modern-form-control" id="plate" name="plate" placeholder="34 ABC 1234">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="chassis_number">Şase Numarası</label>
                                    <input type="text" class="modern-form-control" id="chassis_number" name="chassis_number" placeholder="WVWZZZ1JZ3W386752" maxlength="17">
                                    <div class="form-text" style="font-size: 0.75rem; color: var(--medium-gray);">17 haneli şase numarasını girin</div>
                                </div>
                            </div>
                        </div>

                        <div class="modern-form-group">
                            <label class="modern-form-label" for="mileage">Kilometre</label>
                            <input type="number" class="modern-form-control" id="mileage" name="mileage" placeholder="150000">
                        </div>
                    </div>

                    <!-- Step 3: Hizmet Detayları -->
                    <div class="form-section" id="section3">
                        <h3 class="section-title">Hizmet Detayları</h3>
                        
                        <div class="modern-form-group">
                            <label class="modern-form-label">İhtiyacınız Olan Hizmet Türü *</label>
                            <div class="service-cards">
                                <div class="service-card" data-service="periyodik_bakim">
                                    <div class="service-icon">
                                        <i class="fas fa-oil-can"></i>
                                    </div>
                                    <div class="service-title">Periyodik Bakım</div>
                                    <div class="service-description">Yağ değişimi, filtre değişimi</div>
                                </div>
                                <div class="service-card" data-service="motor_onarim">
                                    <div class="service-icon">
                                        <i class="fas fa-wrench"></i>
                                    </div>
                                    <div class="service-title">Motor Onarımı</div>
                                    <div class="service-description">Motor arızaları ve onarımları</div>
                                </div>
                                <div class="service-card" data-service="kaporta_boya">
                                    <div class="service-icon">
                                        <i class="fas fa-car-crash"></i>
                                    </div>
                                    <div class="service-title">Kaporta & Boya</div>
                                    <div class="service-description">Dış görünüm onarımları</div>
                                </div>
                                <div class="service-card" data-service="genel_onarim">
                                    <div class="service-icon">
                                        <i class="fas fa-cog"></i>
                                    </div>
                                    <div class="service-title">Genel Onarım</div>
                                    <div class="service-description">Fren, süspansiyon vb.</div>
                                </div>
                            </div>
                            <input type="hidden" id="service_type" name="service_type" required>
                            <div class="invalid-feedback"></div>
                        </div>

                        <div class="modern-form-group">
                            <label class="modern-form-label" for="problem_description">Sorun Açıklaması</label>
                            <textarea class="modern-form-control" id="problem_description" name="problem_description" rows="4" placeholder="Aracınızdaki sorunu detaylı olarak açıklayın..."></textarea>
                        </div>

                        <div class="row">
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="preferred_date">Tercih Edilen Tarih</label>
                                    <input type="date" class="modern-form-control" id="preferred_date" name="preferred_date">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="modern-form-group">
                                    <label class="modern-form-label" for="preferred_time">Tercih Edilen Saat</label>
                                    <select class="modern-form-control" id="preferred_time" name="preferred_time">
                                        <option value="">Seçiniz</option>
                                        <option value="09:00">09:00</option>
                                        <option value="10:00">10:00</option>
                                        <option value="11:00">11:00</option>
                                        <option value="14:00">14:00</option>
                                        <option value="15:00">15:00</option>
                                        <option value="16:00">16:00</option>
                                    </select>
                                </div>
                            </div>
                        </div>

                        <div class="modern-form-group">
                            <label class="modern-form-label" for="additional_notes">Ek Notlar</label>
                            <textarea class="modern-form-control" id="additional_notes" name="additional_notes" rows="3" placeholder="Eklemek istediğiniz başka bir bilgi varsa yazabilirsiniz..."></textarea>
                        </div>

                        <!-- Randevu Seçimi -->
                        <div class="modern-form-group">
                            <div class="appointment-section" style="background: var(--light-blue); border-radius: 12px; padding: 1.5rem; border: 2px solid rgba(37, 99, 235, 0.2);">
                                <h6 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1rem;">
                                    <i class="fas fa-calendar-alt me-2"></i>Randevu Almak İster misiniz? (İsteğe Bağlı)
                                </h6>
                                <p style="font-size: 0.875rem; color: var(--dark-gray); margin-bottom: 1rem; line-height: 1.6;">
                                    Teklifinizi aldıktan sonra uygun bir zamanda servisimize gelebilirsiniz. 
                                    İsterseniz şimdi randevu alabilir, daha sonra da değiştirebilirsiniz.
                                </p>
                                
                                <div class="form-check mb-3">
                                    <input class="form-check-input" type="checkbox" id="want_appointment" name="want_appointment" 
                                           style="width: 20px; height: 20px; margin-top: 0.125rem;">
                                    <label class="form-check-label" for="want_appointment" style="margin-left: 0.5rem; font-weight: 500; color: var(--dark-gray);">
                                        Evet, randevu almak istiyorum
                                    </label>
                                </div>
                                
                                <div id="appointment-details" style="display: none;">
                                    <div class="row">
                                        <div class="col-md-6">
                                            <div class="modern-form-group">
                                                <label class="modern-form-label" for="appointment_date">Randevu Tarihi</label>
                                                <input type="date" class="modern-form-control" id="appointment_date" name="appointment_date">
                                                <div class="invalid-feedback"></div>
                                            </div>
                                        </div>
                                        <div class="col-md-6">
                                            <div class="modern-form-group">
                                                <label class="modern-form-label" for="appointment_time">Randevu Saati</label>
                                                <select class="modern-form-control" id="appointment_time" name="appointment_time">
                                                    <option value="">Önce tarih seçin</option>
                                                </select>
                                                <div class="invalid-feedback"></div>
                                            </div>
                                        </div>
                                    </div>
                                    
                                    <div class="modern-form-group">
                                        <label class="modern-form-label" for="appointment_notes">Randevu Notları</label>
                                        <textarea class="modern-form-control" id="appointment_notes" name="appointment_notes" rows="2" 
                                                placeholder="Randevunuz hakkında özel bir notunuz varsa yazabilirsiniz..."></textarea>
                                    </div>
                                    
                                    <div class="alert alert-info" style="font-size: 0.875rem; margin-bottom: 0;">
                                        <i class="fas fa-info-circle me-2"></i>
                                        <strong>Bilgi:</strong> Randevunuz onay bekleyecektir. Size e-posta ile onay bilgisi gönderilecektir.
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- KVKK Onayı -->
                        <div class="modern-form-group">
                            <div class="kvkk-consent" style="background: var(--light-blue); border-radius: 12px; padding: 1.5rem; border: 2px solid rgba(37, 99, 235, 0.2);">
                                <h6 style="color: var(--dark-blue); font-weight: 600; margin-bottom: 1rem;">
                                    <i class="fas fa-shield-alt me-2"></i>Kişisel Verilerin Korunması (KVKK)
                                </h6>
                                <p style="font-size: 0.875rem; color: var(--dark-gray); margin-bottom: 1rem; line-height: 1.6;">
                                    Kişisel verileriniz, teklif hazırlanması, iletişim kurulması ve hizmet sunulması amacıyla 
                                    6698 sayılı Kişisel Verilerin Korunması Kanunu kapsamında işlenecektir. 
                                    Verileriniz üçüncü kişilerle paylaşılmayacak ve sadece belirtilen amaçlar doğrultusunda kullanılacaktır.
                                </p>
                                <div class="form-check" style="margin-bottom: 0;">
                                    <input class="form-check-input" type="checkbox" id="kvkk_consent" name="kvkk_consent" required 
                                           style="width: 20px; height: 20px; margin-top: 0.125rem;">
                                    <label class="form-check-label" for="kvkk_consent" style="margin-left: 0.5rem; font-weight: 500; color: var(--dark-gray);">
                                        Kişisel verilerimin yukarıda belirtilen amaçlar doğrultusunda işlenmesini kabul ediyorum. *
                                    </label>
                                    <div class="invalid-feedback"></div>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Form Navigation -->
                    <div class="form-navigation">
                        <button type="button" class="modern-btn-outline" id="prevBtn" onclick="changeStep(-1)" style="display: none;">
                            <i class="fas fa-arrow-left"></i>Önceki
                        </button>
                        <div></div>
                        <button type="button" class="modern-btn" id="nextBtn" onclick="changeStep(1)">
                            Sonraki<i class="fas fa-arrow-right"></i>
                        </button>
                        <button type="submit" class="modern-btn" id="submitBtn" style="display: none;">
                            <span class="loading-spinner"></span>
                            <i class="fas fa-paper-plane"></i>Teklif Gönder
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        let currentStep = 1;
        const totalSteps = 3;
        let isSubmitting = false;

        // Service type selection
        document.querySelectorAll('.service-card').forEach(card => {
            card.addEventListener('click', function() {
                document.querySelectorAll('.service-card').forEach(c => c.classList.remove('selected'));
                this.classList.add('selected');
                document.getElementById('service_type').value = this.dataset.service;
                validateField(document.getElementById('service_type'));
            });
        });

        // Form validation
        function validateField(field) {
            const value = field.value.trim();
            const isRequired = field.hasAttribute('required');
            let isValid = true;
            let message = '';

            if (isRequired && !value) {
                isValid = false;
                message = 'Bu alan zorunludur.';
            } else if (field.type === 'email' && value && !isValidEmail(value)) {
                isValid = false;
                message = 'Geçerli bir e-posta adresi girin.';
            } else if (field.type === 'tel' && value && !isValidPhone(value)) {
                isValid = false;
                message = 'Geçerli bir telefon numarası girin.';
            } else if (field.name === 'year' && value && (value < 1990 || value > 2024)) {
                isValid = false;
                message = 'Geçerli bir model yılı girin.';
            } else if (field.name === 'chassis_number' && value && !isValidChassisNumber(value)) {
                isValid = false;
                message = 'Şase numarası 17 karakter olmalıdır.';
            } else if (field.type === 'checkbox' && isRequired && !field.checked) {
                isValid = false;
                message = 'Bu onay zorunludur.';
            }

            updateFieldValidation(field, isValid, message);
            return isValid;
        }

        function updateFieldValidation(field, isValid, message) {
            const feedback = field.parentElement.querySelector('.invalid-feedback');
            
            field.classList.remove('is-valid', 'is-invalid');
            
            if (isValid) {
                field.classList.add('is-valid');
                if (feedback) feedback.textContent = '';
            } else {
                field.classList.add('is-invalid');
                if (feedback) feedback.textContent = message;
            }
        }

        function isValidEmail(email) {
            return /^[^\s@]+@[^\s@]+\.[^\s@]+$/.test(email);
        }

        function isValidPhone(phone) {
            return /^[\d\s\-\+\(\)]{10,}$/.test(phone);
        }

        function isValidChassisNumber(chassis) {
            // Şase numarası 17 karakter olmalı ve belirli karakterleri içermemeli (I, O, Q)
            return chassis.length === 17 && /^[A-HJ-NPR-Z0-9]{17}$/.test(chassis.toUpperCase());
        }

        // Step navigation
        function changeStep(direction) {
            if (direction === 1 && !validateCurrentStep()) {
                return;
            }

            const currentSection = document.getElementById(`section${currentStep}`);
            const currentStepEl = document.getElementById(`step${currentStep}`);

            currentSection.classList.remove('active');
            
            if (direction === 1) {
                currentStepEl.classList.add('completed');
                currentStepEl.classList.remove('active');
            }

            currentStep += direction;

            const newSection = document.getElementById(`section${currentStep}`);
            const newStepEl = document.getElementById(`step${currentStep}`);

            newSection.classList.add('active');
            newStepEl.classList.add('active');

            if (direction === -1) {
                const prevStepEl = document.getElementById(`step${currentStep + 1}`);
                prevStepEl.classList.remove('completed');
            }

            updateButtons();
        }

        function validateCurrentStep() {
            const currentSection = document.getElementById(`section${currentStep}`);
            const fields = currentSection.querySelectorAll('input[required], select[required], textarea[required]');
            let isValid = true;

            fields.forEach(field => {
                if (!validateField(field)) {
                    isValid = false;
                }
            });

            // Special validation for service type
            if (currentStep === 3) {
                const serviceType = document.getElementById('service_type');
                if (!serviceType.value) {
                    const feedback = serviceType.parentElement.querySelector('.invalid-feedback');
                    if (feedback) feedback.textContent = 'Lütfen bir hizmet türü seçin.';
                    isValid = false;
                }

                // KVKK onayı kontrolü
                const kvkkConsent = document.getElementById('kvkk_consent');
                if (!kvkkConsent.checked) {
                    const feedback = kvkkConsent.parentElement.querySelector('.invalid-feedback');
                    if (feedback) feedback.textContent = 'KVKK onayı zorunludur.';
                    kvkkConsent.classList.add('is-invalid');
                    isValid = false;
                } else {
                    kvkkConsent.classList.remove('is-invalid');
                    kvkkConsent.classList.add('is-valid');
                }
            }

            return isValid;
        }

        function updateButtons() {
            const prevBtn = document.getElementById('prevBtn');
            const nextBtn = document.getElementById('nextBtn');
            const submitBtn = document.getElementById('submitBtn');

            prevBtn.style.display = currentStep === 1 ? 'none' : 'inline-flex';
            nextBtn.style.display = currentStep === totalSteps ? 'none' : 'inline-flex';
            submitBtn.style.display = currentStep === totalSteps ? 'inline-flex' : 'none';
        }

        // Form submission
        document.getElementById('quoteForm').addEventListener('submit', function(e) {
            e.preventDefault();
            
            if (isSubmitting) return;
            
            if (!validateCurrentStep()) {
                return;
            }

            isSubmitting = true;
            const submitBtn = document.getElementById('submitBtn');
            const spinner = submitBtn.querySelector('.loading-spinner');
            
            submitBtn.disabled = true;
            spinner.style.display = 'inline-block';

            // Submit form
            this.submit();
        });

        // Real-time validation
        document.querySelectorAll('.modern-form-control').forEach(field => {
            field.addEventListener('blur', function() {
                validateField(this);
            });

            field.addEventListener('input', function() {
                // Şase numarası için otomatik büyük harf
                if (this.name === 'chassis_number') {
                    this.value = this.value.toUpperCase();
                }
                
                if (this.classList.contains('is-invalid')) {
                    validateField(this);
                }
            });
        });

        // KVKK checkbox için özel event listener
        document.getElementById('kvkk_consent').addEventListener('change', function() {
            if (this.checked) {
                this.classList.remove('is-invalid');
                this.classList.add('is-valid');
                const feedback = this.parentElement.querySelector('.invalid-feedback');
                if (feedback) feedback.textContent = '';
            }
        });

        // Set minimum date to today
        document.getElementById('preferred_date').min = new Date().toISOString().split('T')[0];

        // Randevu sistemi
        const wantAppointmentCheckbox = document.getElementById('want_appointment');
        const appointmentDetails = document.getElementById('appointment-details');
        const appointmentDateInput = document.getElementById('appointment_date');
        const appointmentTimeSelect = document.getElementById('appointment_time');

        // Randevu checkbox değişikliği
        wantAppointmentCheckbox.addEventListener('change', function() {
            if (this.checked) {
                appointmentDetails.style.display = 'block';
                // Minimum tarih bugün
                const today = new Date();
                const tomorrow = new Date(today);
                tomorrow.setDate(tomorrow.getDate() + 1);
                appointmentDateInput.min = tomorrow.toISOString().split('T')[0];
            } else {
                appointmentDetails.style.display = 'none';
                appointmentDateInput.value = '';
                appointmentTimeSelect.innerHTML = '<option value="">Önce tarih seçin</option>';
            }
        });

        // Randevu tarihi değişikliği
        appointmentDateInput.addEventListener('change', function() {
            const selectedDate = this.value;
            if (selectedDate) {
                loadAvailableTimeSlots(selectedDate);
            } else {
                appointmentTimeSelect.innerHTML = '<option value="">Önce tarih seçin</option>';
            }
        });

        // Müsait saatleri yükle
        function loadAvailableTimeSlots(date) {
            appointmentTimeSelect.innerHTML = '<option value="">Yükleniyor...</option>';
            
            fetch('get_available_slots.php', {
                method: 'POST',
                headers: {
                    'Content-Type': 'application/json',
                },
                body: JSON.stringify({ date: date })
            })
            .then(response => response.json())
            .then(data => {
                appointmentTimeSelect.innerHTML = '<option value="">Saat seçin</option>';
                
                if (data.success && data.slots.length > 0) {
                    data.slots.forEach(slot => {
                        const option = document.createElement('option');
                        option.value = slot;
                        option.textContent = slot.substring(0, 5); // HH:MM formatında göster
                        appointmentTimeSelect.appendChild(option);
                    });
                } else {
                    appointmentTimeSelect.innerHTML = '<option value="">Bu tarihte müsait saat yok</option>';
                }
            })
            .catch(error => {
                console.error('Error:', error);
                appointmentTimeSelect.innerHTML = '<option value="">Hata oluştu</option>';
            });
        }

        // Initialize
        updateButtons();
    </script>
</body>
</html>