<?php
/**
 * PHPMailer Direct Loader
 * Bu dosya PHPMailer sınıflarını doğrudan yükler
 */

// PHPMailer dosya yolları
$phpmailer_base = __DIR__ . '/vendor/phpmailer/phpmailer/src/';

$phpmailer_files = [
    'Exception.php',
    'SMTP.php', 
    'PHPMailer.php'
];

// Debug: Base path kontrol (sadece test sayfası için)
$is_test_page = (basename($_SERVER['SCRIPT_NAME'] ?? '') === 'test_phpmailer.php');

if (!is_dir($phpmailer_base)) {
    if ($is_test_page) echo "<p style='color: red;'>❌ PHPMailer base dizini bulunamadı: $phpmailer_base</p>";
    error_log("PHPMailer base directory not found: $phpmailer_base");
    return;
}

if ($is_test_page) echo "<p><strong>PHPMailer base dizini:</strong> $phpmailer_base ✅</p>";

// Dosyaları sırayla yükle
foreach ($phpmailer_files as $file) {
    $file_path = $phpmailer_base . $file;
    if ($is_test_page) echo "<p>Yükleniyor: $file_path</p>";
    
    if (file_exists($file_path)) {
        try {
            require_once $file_path;
            if ($is_test_page) echo "<p style='color: green;'>✅ Yüklendi: $file</p>";
        } catch (Exception $e) {
            if ($is_test_page) echo "<p style='color: red;'>❌ Yükleme hatası ($file): " . $e->getMessage() . "</p>";
            error_log("PHPMailer file load error ($file): " . $e->getMessage());
        } catch (Error $e) {
            if ($is_test_page) echo "<p style='color: red;'>❌ PHP Error ($file): " . $e->getMessage() . "</p>";
            error_log("PHPMailer file PHP error ($file): " . $e->getMessage());
        }
    } else {
        if ($is_test_page) echo "<p style='color: red;'>❌ Dosya bulunamadı: $file_path</p>";
        error_log("PHPMailer file not found: $file_path");
    }
}

// Sınıfların yüklendiğini kontrol et
$classes = [
    'PHPMailer\PHPMailer\Exception',
    'PHPMailer\PHPMailer\SMTP',
    'PHPMailer\PHPMailer\PHPMailer'
];

foreach ($classes as $class) {
    if (!class_exists($class)) {
        error_log("PHPMailer class not loaded: $class");
    }
}

// Global kontrol
if (!class_exists('PHPMailer\PHPMailer\PHPMailer')) {
    error_log("PHPMailer loading failed!");
}
?>
