<?php
/**
 * Araç Bakım Servisi - Kurulum Scripti
 * Bu dosyayı sadece ilk kurulumda çalıştırın!
 */

// Güvenlik kontrolü
if (file_exists('INSTALLED')) {
    die('Sistem zaten kurulmuş! Bu dosyayı silin veya INSTALLED dosyasını silin.');
}

$error = '';
$success = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? 'arac_bakim';
    $db_user = $_POST['db_user'] ?? 'root';
    $db_pass = $_POST['db_pass'] ?? '';
    
    $admin_username = $_POST['admin_username'] ?? 'admin';
    $admin_email = $_POST['admin_email'] ?? 'admin@aracbakim.com';
    $admin_password = $_POST['admin_password'] ?? '';
    $admin_first_name = $_POST['admin_first_name'] ?? 'Admin';
    $admin_last_name = $_POST['admin_last_name'] ?? 'User';
    
    try {
        // Veritabanı bağlantısı
        $pdo = new PDO("mysql:host=$db_host;charset=utf8mb4", $db_user, $db_pass);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Veritabanını oluştur
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $pdo->exec("USE `$db_name`");
        
        // SQL dosyasını oku ve çalıştır
        $sql = file_get_contents('database/schema.sql');
        
        // SQL'i noktalı virgülle böl ve her komutu ayrı çalıştır
        $statements = array_filter(array_map('trim', explode(';', $sql)));
        
        foreach ($statements as $statement) {
            if (!empty($statement) && !preg_match('/^(CREATE DATABASE|USE)/i', $statement)) {
                $pdo->exec($statement);
            }
        }
        
        // Admin kullanıcısını güncelle
        $admin_password_hash = password_hash($admin_password, PASSWORD_DEFAULT);
        $stmt = $pdo->prepare("
            UPDATE users 
            SET username = ?, email = ?, password_hash = ?, first_name = ?, last_name = ?
            WHERE id = 1
        ");
        $stmt->execute([$admin_username, $admin_email, $admin_password_hash, $admin_first_name, $admin_last_name]);
        
        // Config dosyasını güncelle
        $config_content = file_get_contents('config/config.php');
        $config_content = str_replace("define('DB_HOST', 'localhost');", "define('DB_HOST', '$db_host');", $config_content);
        $config_content = str_replace("define('DB_NAME', 'arac_bakim');", "define('DB_NAME', '$db_name');", $config_content);
        $config_content = str_replace("define('DB_USER', 'root');", "define('DB_USER', '$db_user');", $config_content);
        $config_content = str_replace("define('DB_PASS', '');", "define('DB_PASS', '$db_pass');", $config_content);
        
        file_put_contents('config/config.php', $config_content);
        
        // Kurulum tamamlandı işareti
        file_put_contents('INSTALLED', date('Y-m-d H:i:s'));
        
        $success = 'Kurulum başarıyla tamamlandı! Artık sistemi kullanabilirsiniz.';
        
    } catch (Exception $e) {
        $error = 'Kurulum hatası: ' . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Kurulum - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        body {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            min-height: 100vh;
            font-family: 'Segoe UI', Tahoma, Geneva, Verdana, sans-serif;
        }
        .install-card {
            background: rgba(255, 255, 255, 0.95);
            backdrop-filter: blur(10px);
            border-radius: 1rem;
            box-shadow: 0 20px 25px -5px rgb(0 0 0 / 0.1);
        }
        .install-header {
            background: linear-gradient(135deg, #2563eb 0%, #1d4ed8 100%);
            color: white;
            border-radius: 1rem 1rem 0 0;
        }
    </style>
</head>
<body>
    <div class="container">
        <div class="row justify-content-center align-items-center min-vh-100 py-5">
            <div class="col-lg-6">
                <div class="install-card">
                    <div class="install-header p-4 text-center">
                        <h2><i class="fas fa-car fa-2x mb-3"></i></h2>
                        <h3>Araç Bakım Servisi</h3>
                        <p class="mb-0">Sistem Kurulumu</p>
                    </div>
                    
                    <div class="p-4">
                        <?php if ($error): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i> <?= htmlspecialchars($error) ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($success): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i> <?= htmlspecialchars($success) ?>
                            </div>
                            <div class="text-center mt-4">
                                <a href="index.php" class="btn btn-primary btn-lg me-3">
                                    <i class="fas fa-home"></i> Ana Sayfa
                                </a>
                                <a href="admin/login.php" class="btn btn-success btn-lg">
                                    <i class="fas fa-sign-in-alt"></i> Admin Girişi
                                </a>
                            </div>
                        <?php else: ?>
                            <form method="POST">
                                <h5 class="mb-3"><i class="fas fa-database text-primary"></i> Veritabanı Ayarları</h5>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="db_host" class="form-label">Veritabanı Sunucusu</label>
                                        <input type="text" class="form-control" id="db_host" name="db_host" value="localhost" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="db_name" class="form-label">Veritabanı Adı</label>
                                        <input type="text" class="form-control" id="db_name" name="db_name" value="arac_bakim" required>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="db_user" class="form-label">Kullanıcı Adı</label>
                                        <input type="text" class="form-control" id="db_user" name="db_user" value="root" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="db_pass" class="form-label">Şifre</label>
                                        <input type="password" class="form-control" id="db_pass" name="db_pass" placeholder="Boş bırakabilirsiniz">
                                    </div>
                                </div>
                                
                                <hr class="my-4">
                                
                                <h5 class="mb-3"><i class="fas fa-user-shield text-success"></i> Admin Kullanıcı</h5>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_first_name" class="form-label">Ad</label>
                                        <input type="text" class="form-control" id="admin_first_name" name="admin_first_name" value="Admin" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_last_name" class="form-label">Soyad</label>
                                        <input type="text" class="form-control" id="admin_last_name" name="admin_last_name" value="User" required>
                                    </div>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_username" class="form-label">Kullanıcı Adı</label>
                                        <input type="text" class="form-control" id="admin_username" name="admin_username" value="admin" required>
                                    </div>
                                    <div class="col-md-6 mb-3">
                                        <label for="admin_email" class="form-label">E-posta</label>
                                        <input type="email" class="form-control" id="admin_email" name="admin_email" value="admin@aracbakim.com" required>
                                    </div>
                                </div>
                                
                                <div class="mb-4">
                                    <label for="admin_password" class="form-label">Şifre</label>
                                    <input type="password" class="form-control" id="admin_password" name="admin_password" required>
                                    <small class="form-text text-muted">En az 6 karakter olmalıdır</small>
                                </div>
                                
                                <div class="d-grid">
                                    <button type="submit" class="btn btn-primary btn-lg">
                                        <i class="fas fa-rocket"></i> Kurulumu Başlat
                                    </button>
                                </div>
                            </form>
                        <?php endif; ?>
                    </div>
                </div>
                
                <?php if (!$success): ?>
                <div class="text-center mt-4">
                    <div class="alert alert-info">
                        <h6><i class="fas fa-info-circle"></i> Kurulum Öncesi Kontrol Listesi</h6>
                        <ul class="list-unstyled mb-0">
                            <li><i class="fas fa-check text-success"></i> PHP 7.4+ kurulu olmalı</li>
                            <li><i class="fas fa-check text-success"></i> MySQL/MariaDB çalışıyor olmalı</li>
                            <li><i class="fas fa-check text-success"></i> PDO MySQL extension aktif olmalı</li>
                            <li><i class="fas fa-check text-success"></i> Dosya yazma izinleri verilmeli</li>
                        </ul>
                    </div>
                </div>
                <?php endif; ?>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
