<?php
/**
 * Müsait randevu saatlerini getiren API
 */

header('Content-Type: application/json');

try {
    require_once 'config/config.php';
    require_once 'includes/appointment_functions.php';
    
    if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
        throw new Exception('Geçersiz istek metodu.');
    }
    
    $input = json_decode(file_get_contents('php://input'), true);
    
    if (!isset($input['date'])) {
        throw new Exception('Tarih belirtilmedi.');
    }
    
    $date = $input['date'];
    
    // Tarih formatını kontrol et
    if (!preg_match('/^\d{4}-\d{2}-\d{2}$/', $date)) {
        throw new Exception('Geçersiz tarih formatı.');
    }
    
    // Geçmiş tarih kontrolü
    if (strtotime($date) < strtotime('today')) {
        throw new Exception('Geçmiş tarih seçilemez.');
    }
    
    // Çok ileri tarih kontrolü (30 gün)
    $maxDate = date('Y-m-d', strtotime('+30 days'));
    if ($date > $maxDate) {
        throw new Exception('En fazla 30 gün sonrası için randevu alabilirsiniz.');
    }
    
    // Müsait saatleri getir
    $availableSlots = getAvailableTimeSlots($date);
    
    echo json_encode([
        'success' => true,
        'date' => $date,
        'slots' => $availableSlots,
        'count' => count($availableSlots)
    ]);
    
} catch (Exception $e) {
    http_response_code(400);
    echo json_encode([
        'success' => false,
        'message' => $e->getMessage()
    ]);
}
?>
