<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';

$success_message = '';
$error_message = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $name = trim($_POST['name'] ?? '');
    $email = trim($_POST['email'] ?? '');
    $phone = trim($_POST['phone'] ?? '');
    $subject = trim($_POST['subject'] ?? '');
    $message = trim($_POST['message'] ?? '');
    
    $errors = [];
    
    if (empty($name)) $errors[] = 'Ad soyad gereklidir.';
    if (empty($email) || !validateEmail($email)) $errors[] = 'Geçerli bir e-posta adresi gereklidir.';
    if (empty($phone)) $errors[] = 'Telefon numarası gereklidir.';
    if (empty($subject)) $errors[] = 'Konu gereklidir.';
    if (empty($message)) $errors[] = 'Mesaj gereklidir.';
    
    if (empty($errors)) {
        try {
            // E-posta gönder
            $email_subject = "İletişim Formu: " . $subject;
            $email_message = "
                <h3>Yeni İletişim Formu Mesajı</h3>
                <p><strong>Ad Soyad:</strong> {$name}</p>
                <p><strong>E-posta:</strong> {$email}</p>
                <p><strong>Telefon:</strong> {$phone}</p>
                <p><strong>Konu:</strong> {$subject}</p>
                <p><strong>Mesaj:</strong></p>
                <p>{$message}</p>
                <hr>
                <p><small>Bu mesaj " . SITE_URL . " adresindeki iletişim formundan gönderilmiştir.</small></p>
            ";
            
            // E-posta fonksiyonlarını dahil et
            require_once 'includes/email_functions.php';
            if (sendEmail(ADMIN_EMAIL, $email_subject, $email_message)) {
                $success_message = 'Mesajınız başarıyla gönderildi. En kısa sürede size dönüş yapacağız.';
                
                // Formu temizle
                $name = $email = $phone = $subject = $message = '';
            } else {
                $error_message = 'Mesaj gönderilirken bir hata oluştu. Lütfen tekrar deneyiniz.';
            }
            
        } catch (Exception $e) {
            error_log("Contact form error: " . $e->getMessage());
            $error_message = 'Bir hata oluştu. Lütfen tekrar deneyiniz.';
        }
    } else {
        $error_message = implode('<br>', $errors);
    }
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>İletişim - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car"></i> Araç Bakım Servisi
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="about.php">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="contact.php">İletişim</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link btn btn-warning text-dark px-3 ms-2" href="quote_form.php">
                            <i class="fas fa-clipboard-list"></i> Teklif Al
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <div class="container mt-5">
        <!-- Sayfa Başlığı -->
        <div class="row justify-content-center mb-5">
            <div class="col-lg-8 text-center">
                <h1 class="display-4 fw-bold text-gradient mb-4">İletişim</h1>
                <p class="lead text-muted">
                    Sorularınız için bize ulaşın. Uzman ekibimiz size yardımcı olmaktan mutluluk duyar.
                </p>
            </div>
        </div>

        <div class="row">
            <!-- Sol Kolon - İletişim Formu -->
            <div class="col-lg-8">
                <div class="card shadow-lg">
                    <div class="card-header bg-gradient text-white">
                        <h4><i class="fas fa-envelope"></i> Bize Mesaj Gönderin</h4>
                    </div>
                    <div class="card-body p-4">
                        <?php if ($success_message): ?>
                            <div class="alert alert-success">
                                <i class="fas fa-check-circle"></i> <?= h($success_message) ?>
                            </div>
                        <?php endif; ?>
                        
                        <?php if ($error_message): ?>
                            <div class="alert alert-danger">
                                <i class="fas fa-exclamation-triangle"></i> <?= $error_message ?>
                            </div>
                        <?php endif; ?>
                        
                        <form method="POST" action="">
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="name" class="form-label">Ad Soyad *</label>
                                    <input type="text" class="form-control" id="name" name="name" 
                                           value="<?= h($name ?? '') ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">E-posta *</label>
                                    <input type="email" class="form-control" id="email" name="email" 
                                           value="<?= h($email ?? '') ?>" required>
                                </div>
                            </div>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="phone" class="form-label">Telefon *</label>
                                    <input type="tel" class="form-control" id="phone" name="phone" 
                                           value="<?= h($phone ?? '') ?>" required>
                                </div>
                                <div class="col-md-6 mb-3">
                                    <label for="subject" class="form-label">Konu *</label>
                                    <select class="form-select" id="subject" name="subject" required>
                                        <option value="">Konu Seçin</option>
                                        <option value="Genel Bilgi" <?= ($subject ?? '') === 'Genel Bilgi' ? 'selected' : '' ?>>Genel Bilgi</option>
                                        <option value="Teklif Talebi" <?= ($subject ?? '') === 'Teklif Talebi' ? 'selected' : '' ?>>Teklif Talebi</option>
                                        <option value="Randevu" <?= ($subject ?? '') === 'Randevu' ? 'selected' : '' ?>>Randevu</option>
                                        <option value="Şikayet" <?= ($subject ?? '') === 'Şikayet' ? 'selected' : '' ?>>Şikayet</option>
                                        <option value="Öneri" <?= ($subject ?? '') === 'Öneri' ? 'selected' : '' ?>>Öneri</option>
                                        <option value="Diğer" <?= ($subject ?? '') === 'Diğer' ? 'selected' : '' ?>>Diğer</option>
                                    </select>
                                </div>
                            </div>
                            
                            <div class="mb-4">
                                <label for="message" class="form-label">Mesajınız *</label>
                                <textarea class="form-control" id="message" name="message" rows="5" 
                                          placeholder="Mesajınızı buraya yazın..." required><?= h($message ?? '') ?></textarea>
                            </div>
                            
                            <div class="d-grid">
                                <button type="submit" class="btn btn-primary btn-lg">
                                    <i class="fas fa-paper-plane"></i> Mesaj Gönder
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>

            <!-- Sağ Kolon - İletişim Bilgileri -->
            <div class="col-lg-4">
                <!-- İletişim Bilgileri -->
                <div class="card shadow-lg mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-map-marker-alt text-danger"></i> İletişim Bilgileri</h5>
                    </div>
                    <div class="card-body">
                        <div class="contact-item mb-4">
                            <div class="d-flex align-items-start">
                                <div class="contact-icon">
                                    <i class="fas fa-map-marker-alt text-danger"></i>
                                </div>
                                <div class="ms-3">
                                    <h6>Adres</h6>
                                    <p class="text-muted mb-0">
                                        Örnek Mahallesi, Bakım Caddesi No:123<br>
                                        Kadıköy / İstanbul
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="contact-item mb-4">
                            <div class="d-flex align-items-start">
                                <div class="contact-icon">
                                    <i class="fas fa-phone text-success"></i>
                                </div>
                                <div class="ms-3">
                                    <h6>Telefon</h6>
                                    <p class="mb-1">
                                        <a href="tel:02121234567" class="text-decoration-none">
                                            0212 123 45 67
                                        </a>
                                    </p>
                                    <p class="mb-0">
                                        <a href="tel:05551234567" class="text-decoration-none">
                                            0555 123 45 67 (WhatsApp)
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="contact-item mb-4">
                            <div class="d-flex align-items-start">
                                <div class="contact-icon">
                                    <i class="fas fa-envelope text-primary"></i>
                                </div>
                                <div class="ms-3">
                                    <h6>E-posta</h6>
                                    <p class="mb-1">
                                        <a href="mailto:info@aracbakim.com" class="text-decoration-none">
                                            info@aracbakim.com
                                        </a>
                                    </p>
                                    <p class="mb-0">
                                        <a href="mailto:destek@aracbakim.com" class="text-decoration-none">
                                            destek@aracbakim.com
                                        </a>
                                    </p>
                                </div>
                            </div>
                        </div>
                        
                        <div class="contact-item">
                            <div class="d-flex align-items-start">
                                <div class="contact-icon">
                                    <i class="fas fa-clock text-warning"></i>
                                </div>
                                <div class="ms-3">
                                    <h6>Çalışma Saatleri</h6>
                                    <p class="mb-1"><strong>Pazartesi - Cumartesi:</strong> 08:00 - 18:00</p>
                                    <p class="mb-0"><strong>Pazar:</strong> 09:00 - 17:00</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Sosyal Medya -->
                <div class="card shadow-lg mb-4">
                    <div class="card-header">
                        <h5><i class="fas fa-share-alt text-info"></i> Sosyal Medya</h5>
                    </div>
                    <div class="card-body text-center">
                        <div class="d-flex justify-content-center gap-3">
                            <a href="#" class="btn btn-outline-primary btn-lg">
                                <i class="fab fa-facebook-f"></i>
                            </a>
                            <a href="#" class="btn btn-outline-info btn-lg">
                                <i class="fab fa-twitter"></i>
                            </a>
                            <a href="#" class="btn btn-outline-danger btn-lg">
                                <i class="fab fa-instagram"></i>
                            </a>
                            <a href="#" class="btn btn-outline-success btn-lg">
                                <i class="fab fa-whatsapp"></i>
                            </a>
                        </div>
                    </div>
                </div>

                <!-- Acil Durum -->
                <div class="card shadow-lg bg-danger text-white">
                    <div class="card-body text-center">
                        <h5><i class="fas fa-exclamation-triangle"></i> Acil Durum</h5>
                        <p class="mb-3">24 saat acil yol yardımı için:</p>
                        <a href="tel:05551234567" class="btn btn-light btn-lg">
                            <i class="fas fa-phone"></i> 0555 123 45 67
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- Harita Bölümü -->
        <div class="row mt-5">
            <div class="col-12">
                <div class="card shadow-lg">
                    <div class="card-header">
                        <h5><i class="fas fa-map text-success"></i> Konum</h5>
                    </div>
                    <div class="card-body p-0">
                        <div class="map-container" style="height: 400px; background: #f8f9fa;">
                            <div class="d-flex align-items-center justify-content-center h-100">
                                <div class="text-center">
                                    <i class="fas fa-map-marker-alt fa-3x text-muted mb-3"></i>
                                    <p class="text-muted">Harita entegrasyonu için Google Maps API gereklidir.</p>
                                    <a href="https://maps.google.com" target="_blank" class="btn btn-primary">
                                        <i class="fas fa-external-link-alt"></i> Google Maps'te Aç
                                    </a>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4 mt-5">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-car fa-2x text-warning me-3"></i>
                        <div>
                            <h6 class="mb-0">Araç Bakım Servisi</h6>
                            <small>Profesyonel araç bakım hizmetleri</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; 2024 Araç Bakım Servisi. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        // Telefon formatlaması
        document.getElementById('phone').addEventListener('input', function(e) {
            let value = e.target.value.replace(/\D/g, '');
            
            if (value.length > 0) {
                if (value.length <= 3) {
                    value = value;
                } else if (value.length <= 6) {
                    value = value.slice(0, 3) + ' ' + value.slice(3);
                } else if (value.length <= 8) {
                    value = value.slice(0, 3) + ' ' + value.slice(3, 6) + ' ' + value.slice(6);
                } else {
                    value = value.slice(0, 3) + ' ' + value.slice(3, 6) + ' ' + value.slice(6, 8) + ' ' + value.slice(8, 10);
                }
            }
            
            e.target.value = value;
        });

        // Form animasyonu
        document.addEventListener('DOMContentLoaded', function() {
            const cards = document.querySelectorAll('.card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(20px)';
                
                setTimeout(() => {
                    card.style.transition = 'all 0.5s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 200);
            });
        });
    </script>

    <style>
        .contact-icon {
            width: 40px;
            height: 40px;
            border-radius: 50%;
            background: rgba(37, 99, 235, 0.1);
            display: flex;
            align-items: center;
            justify-content: center;
            font-size: 1.2rem;
        }
        
        .contact-item {
            transition: transform 0.3s ease;
        }
        
        .contact-item:hover {
            transform: translateX(5px);
        }
    </style>
</body>
</html>
