<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

$pageTitle = 'Ürün/Hizmetler';
$currentPage = 'products';

// Sayfalama
$page = intval($_GET['page'] ?? 1);
$limit = 20;
$offset = ($page - 1) * $limit;

// Filtreleme
$search = trim($_GET['search'] ?? '');
$category_filter = intval($_GET['category'] ?? 0);
$type_filter = $_GET['type'] ?? '';

// Kategorileri al
$stmt = $pdo->query("SELECT * FROM product_categories WHERE is_active = 1 ORDER BY name");
$categories = $stmt->fetchAll();

// Ürünleri al
$where_conditions = ['p.is_active = 1'];
$params = [];

if ($search) {
    $where_conditions[] = "(p.name LIKE ? OR p.description LIKE ? OR p.sku LIKE ?)";
    $params[] = "%$search%";
    $params[] = "%$search%";
    $params[] = "%$search%";
}

if ($category_filter) {
    $where_conditions[] = "p.category_id = ?";
    $params[] = $category_filter;
}

if ($type_filter) {
    $where_conditions[] = "p.type = ?";
    $params[] = $type_filter;
}

$where_clause = implode(' AND ', $where_conditions);

// Toplam kayıt sayısı
$count_sql = "SELECT COUNT(*) as total FROM products p WHERE $where_clause";
$stmt = $pdo->prepare($count_sql);
$stmt->execute($params);
$total_records = $stmt->fetch()['total'];

// Ürünleri getir
$sql = "
    SELECT p.*, pc.name as category_name
    FROM products p
    LEFT JOIN product_categories pc ON p.category_id = pc.id
    WHERE $where_clause
    ORDER BY p.created_at DESC
    LIMIT $limit OFFSET $offset
";

$stmt = $pdo->prepare($sql);
$stmt->execute($params);
$products = $stmt->fetchAll();

$pagination = calculatePagination($total_records, $page, $limit);
?>
<?php require_once 'includes/header.php'; ?>
        <section class="section">
            <div class="row mb-4">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <div></div>
                        <div class="d-flex gap-2">
                            <a href="product_add.php" class="nice-btn nice-btn-primary">
                                <i class="fas fa-plus"></i> Yeni Ekle
                            </a>
                            <a href="categories.php" class="nice-btn nice-btn-outline-primary">
                                <i class="fas fa-tags"></i> Kategoriler
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Filtreler -->
            <div class="nice-card mb-4">
                <div class="card-body">
                    <h5 class="card-title">Filtreler</h5>
                        <form method="GET" class="row g-3">
                            <div class="col-md-4">
                                <label for="search" class="form-label">Arama</label>
                                <input type="text" class="nice-form-control" id="search" name="search" 
                                       value="<?= h($search) ?>" placeholder="Ürün adı, açıklama veya SKU">
                            </div>
                            <div class="col-md-3">
                                <label for="category" class="form-label">Kategori</label>
                                <select class="nice-form-control" id="category" name="category">
                                    <option value="">Tüm Kategoriler</option>
                                    <?php foreach ($categories as $category): ?>
                                        <option value="<?= $category['id'] ?>" <?= $category_filter == $category['id'] ? 'selected' : '' ?>>
                                            <?= h($category['name']) ?>
                                        </option>
                                    <?php endforeach; ?>
                                </select>
                            </div>
                            <div class="col-md-3">
                                <label for="type" class="form-label">Tür</label>
                                <select class="nice-form-control" id="type" name="type">
                                    <option value="">Tüm Türler</option>
                                    <option value="part" <?= $type_filter === 'part' ? 'selected' : '' ?>>Parça</option>
                                    <option value="service" <?= $type_filter === 'service' ? 'selected' : '' ?>>Hizmet</option>
                                    <option value="package" <?= $type_filter === 'package' ? 'selected' : '' ?>>Paket</option>
                                </select>
                            </div>
                            <div class="col-md-2">
                                <label class="form-label">&nbsp;</label>
                                <div class="d-grid">
                                    <button type="submit" class="nice-btn nice-btn-primary">
                                        <i class="fas fa-search"></i> Filtrele
                                    </button>
                                </div>
                            </div>
                        </form>
                    </div>
                </div>

                <!-- Ürün Listesi -->
                <div class="nice-card">
                    <div class="card-body">
                        <h5 class="card-title">Ürün/Hizmet Listesi <span class="nice-badge nice-badge-primary"><?= $total_records ?></span></h5>
                        <?php if (empty($products)): ?>
                            <div class="text-center py-5">
                                <i class="fas fa-box-open fa-3x text-muted mb-3"></i>
                                <p class="text-muted">Henüz ürün/hizmet bulunmuyor.</p>
                                <a href="product_add.php" class="nice-btn nice-btn-primary">
                                    <i class="fas fa-plus"></i> İlk Ürünü Ekle
                                </a>
                            </div>
                        <?php else: ?>
                            <div class="table-responsive">
                                <table class="nice-table table-hover">
                                    <thead>
                                        <tr>
                                            <th>SKU</th>
                                            <th>Ürün/Hizmet</th>
                                            <th>Kategori</th>
                                            <th>Tür</th>
                                            <th>Fiyat</th>
                                            <th>Stok</th>
                                            <th>Durum</th>
                                            <th>İşlemler</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($products as $product): ?>
                                        <tr>
                                            <td>
                                                <code><?= h($product['sku']) ?></code>
                                            </td>
                                            <td>
                                                <div>
                                                    <strong><?= h($product['name']) ?></strong>
                                                    <?php if ($product['description']): ?>
                                                        <br><small class="text-muted"><?= h(substr($product['description'], 0, 50)) ?>...</small>
                                                    <?php endif; ?>
                                                </div>
                                            </td>
                                            <td>
                                                <?php if ($product['category_name']): ?>
                                                    <span class="nice-badge nice-badge-secondary"><?= h($product['category_name']) ?></span>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php
                                                $typeIcons = [
                                                    'part' => 'fas fa-cog text-primary',
                                                    'service' => 'fas fa-tools text-success',
                                                    'package' => 'fas fa-box text-warning'
                                                ];
                                                $typeNames = [
                                                    'part' => 'Parça',
                                                    'service' => 'Hizmet',
                                                    'package' => 'Paket'
                                                ];
                                                ?>
                                                <i class="<?= $typeIcons[$product['type']] ?? 'fas fa-question' ?>"></i>
                                                <?= $typeNames[$product['type']] ?? $product['type'] ?>
                                            </td>
                                            <td>
                                                <strong><?= formatMoney($product['price']) ?></strong>
                                                <?php if ($product['cost_price']): ?>
                                                    <br><small class="text-muted">Maliyet: <?= formatMoney($product['cost_price']) ?></small>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($product['type'] === 'part'): ?>
                                                    <?php if ($product['stock_quantity'] <= $product['min_stock_level']): ?>
                                                        <span class="nice-badge nice-badge-danger"><?= $product['stock_quantity'] ?></span>
                                                        <br><small class="text-danger">Kritik Seviye</small>
                                                    <?php else: ?>
                                                        <span class="nice-badge nice-badge-success"><?= $product['stock_quantity'] ?></span>
                                                    <?php endif; ?>
                                                <?php else: ?>
                                                    <span class="text-muted">-</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <?php if ($product['is_active']): ?>
                                                    <span class="nice-badge nice-badge-success">Aktif</span>
                                                <?php else: ?>
                                                    <span class="nice-badge nice-badge-danger">Pasif</span>
                                                <?php endif; ?>
                                            </td>
                                            <td>
                                                <div class="btn-group btn-group-sm">
                                                    <a href="product_edit.php?id=<?= $product['id'] ?>" class="nice-btn nice-btn-outline-primary btn-sm" title="Düzenle">
                                                        <i class="fas fa-edit"></i>
                                                    </a>
                                                    <button type="button" class="nice-btn nice-btn-danger btn-sm" title="Sil" 
                                                            onclick="deleteProduct(<?= $product['id'] ?>, '<?= h($product['name']) ?>')">
                                                        <i class="fas fa-trash"></i>
                                                    </button>
                                                </div>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>

                            <!-- Sayfalama -->
                            <?php if ($pagination['total_pages'] > 1): ?>
                                <nav aria-label="Sayfa navigasyonu" class="mt-4">
                                    <ul class="pagination justify-content-center">
                                        <?php if ($pagination['has_previous']): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="?page=<?= $pagination['current_page'] - 1 ?>&search=<?= urlencode($search) ?>&category=<?= $category_filter ?>&type=<?= urlencode($type_filter) ?>">
                                                    <i class="fas fa-chevron-left"></i>
                                                </a>
                                            </li>
                                        <?php endif; ?>

                                        <?php for ($i = max(1, $pagination['current_page'] - 2); $i <= min($pagination['total_pages'], $pagination['current_page'] + 2); $i++): ?>
                                            <li class="page-item <?= $i === $pagination['current_page'] ? 'active' : '' ?>">
                                                <a class="page-link" href="?page=<?= $i ?>&search=<?= urlencode($search) ?>&category=<?= $category_filter ?>&type=<?= urlencode($type_filter) ?>">
                                                    <?= $i ?>
                                                </a>
                                            </li>
                                        <?php endfor; ?>

                                        <?php if ($pagination['has_next']): ?>
                                            <li class="page-item">
                                                <a class="page-link" href="?page=<?= $pagination['current_page'] + 1 ?>&search=<?= urlencode($search) ?>&category=<?= $category_filter ?>&type=<?= urlencode($type_filter) ?>">
                                                    <i class="fas fa-chevron-right"></i>
                                                </a>
                                            </li>
                                        <?php endif; ?>
                                    </ul>
                                </nav>
                            <?php endif; ?>
                        <?php endif; ?>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="../assets/js/main.js"></script>
    <script>
        function deleteProduct(id, name) {
            if (confirm(`"${name}" ürününü silmek istediğinizden emin misiniz?`)) {
                fetch('product_delete.php', {
                    method: 'POST',
                    headers: {
                        'Content-Type': 'application/x-www-form-urlencoded',
                    },
                    body: `id=${id}`
                })
                .then(response => response.json())
                .then(data => {
                    if (data.success) {
                        AracBakim.showAlert('success', data.message);
                        setTimeout(() => location.reload(), 1500);
                    } else {
                        AracBakim.showAlert('danger', data.message);
                    }
                })
                .catch(error => {
                    console.error('Error:', error);
                    AracBakim.showAlert('danger', 'Bir hata oluştu.');
                });
            }
        }
    </script>
<?php require_once 'includes/footer.php'; ?>
