<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

if (!isLoggedIn()) {
    redirect('login.php');
}

$product_id = intval($_GET['id'] ?? 0);
if (!$product_id) {
    $_SESSION['error_message'] = 'Geçersiz ürün ID.';
    redirect('products.php');
}

try {
    // Ürün bilgilerini al
    $stmt = $pdo->prepare("SELECT * FROM products WHERE id = ?");
    $stmt->execute([$product_id]);
    $product = $stmt->fetch();
    
    if (!$product) {
        $_SESSION['error_message'] = 'Ürün bulunamadı.';
        redirect('products.php');
    }
    
    // Ürünün kullanılıp kullanılmadığını kontrol et
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_items WHERE product_id = ?");
    $stmt->execute([$product_id]);
    $usage_count = $stmt->fetch()['count'];
    
    if ($usage_count > 0) {
        $_SESSION['error_message'] = 'Bu ürün mevcut tekliflerde kullanıldığı için silinemez. Önce ürünü pasif yapabilirsiniz.';
        redirect('product_edit.php?id=' . $product_id);
    }
    
    // Ürünü sil
    $stmt = $pdo->prepare("DELETE FROM products WHERE id = ?");
    $stmt->execute([$product_id]);
    
    // Audit log
    logAudit('product_deleted', 'products', $product_id, null, [
        'name' => $product['name'],
        'sku' => $product['sku'],
        'deleted_by' => $_SESSION['user_id']
    ]);
    
    $_SESSION['success_message'] = 'Ürün başarıyla silindi.';
    redirect('products.php');
    
} catch (Exception $e) {
    error_log("Product delete error: " . $e->getMessage());
    $_SESSION['error_message'] = 'Ürün silinirken hata oluştu: ' . $e->getMessage();
    redirect('products.php');
}
?>
