<?php
// Bekleyen başvuru sayısı sidebar için
try {
    $stmt = $pdo->prepare("SELECT COUNT(*) as count FROM quote_requests WHERE status = 'NEW'");
    $stmt->execute();
    $pendingQuotes = $stmt->fetch()['count'];
} catch (Exception $e) {
    $pendingQuotes = 0;
}
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?= $pageTitle ?? 'Admin Panel' ?> - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Open+Sans:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Nunito:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="https://fonts.googleapis.com/css2?family=Poppins:wght@300;400;500;600;700;800&display=swap" rel="stylesheet">
    <link href="../assets/css/style.css" rel="stylesheet">
</head>
<body class="nice-body">
    <!-- NiceAdmin Sidebar -->
    <aside id="sidebar" class="nice-sidebar">
        <ul class="sidebar-nav" id="sidebar-nav">
            <li class="nav-item">
                <div class="text-center mb-4 p-3">
                    <i class="fas fa-car text-primary fa-2x"></i>
                    <h6 class="text-primary mt-2 mb-0">Araç Bakım</h6>
                </div>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'dashboard' ? 'active' : '' ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i>
                    <span>Dashboard</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'quotes' ? 'active' : '' ?>" href="quotes.php">
                    <i class="fas fa-clipboard-list"></i>
                    <span>Teklif Başvuruları</span>
                    <?php if ($pendingQuotes > 0): ?>
                        <span class="nice-badge nice-badge-danger ms-2"><?= $pendingQuotes ?></span>
                    <?php endif; ?>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'appointments' ? 'active' : '' ?>" href="appointments.php">
                    <i class="fas fa-calendar-alt"></i>
                    <span>Randevular</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'orders' ? 'active' : '' ?>" href="orders.php">
                    <i class="fas fa-shopping-cart"></i>
                    <span>Siparişler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'customers' ? 'active' : '' ?>" href="customers.php">
                    <i class="fas fa-users"></i>
                    <span>Müşteriler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'products' ? 'active' : '' ?>" href="products.php">
                    <i class="fas fa-box"></i>
                    <span>Ürün/Hizmetler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'categories' ? 'active' : '' ?>" href="categories.php">
                    <i class="fas fa-tags"></i>
                    <span>Kategoriler</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'reports' ? 'active' : '' ?>" href="reports.php">
                    <i class="fas fa-chart-bar"></i>
                    <span>Raporlar</span>
                </a>
            </li>
            
            <?php if (isAdmin()): ?>
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'settings' ? 'active' : '' ?>" href="settings.php">
                    <i class="fas fa-cog"></i>
                    <span>Ayarlar</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'email_setup' ? 'active' : '' ?>" href="email_setup.php">
                    <i class="fas fa-cogs"></i>
                    <span>E-posta Kurulumu</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'test_email' ? 'active' : '' ?>" href="test_email.php">
                    <i class="fas fa-envelope-open-text"></i>
                    <span>E-posta Test</span>
                </a>
            </li>
            
            <li class="nav-item">
                <a class="nav-link <?= ($currentPage ?? '') === 'users' ? 'active' : '' ?>" href="users.php">
                    <i class="fas fa-user-cog"></i>
                    <span>Kullanıcılar</span>
                </a>
            </li>
            <?php endif; ?>
            
            <li class="nav-item mt-4">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i>
                    <span>Çıkış</span>
                </a>
            </li>
        </ul>
    </aside>

    <!-- NiceAdmin Header -->
    <header id="header" class="nice-header">
        <div class="d-flex align-items-center justify-content-between">
            <div class="logo d-flex align-items-center">
                <span class="d-none d-lg-block"><?= $pageTitle ?? 'Admin Panel' ?></span>
            </div>
            <nav class="header-nav ms-auto">
                <ul class="d-flex align-items-center">
                    <li class="nav-item dropdown pe-3">
                        <a class="nav-link nav-profile d-flex align-items-center pe-0" href="#" data-bs-toggle="dropdown">
                            <i class="fas fa-user-circle fa-2x text-primary"></i>
                            <span class="d-none d-md-block dropdown-toggle ps-2"><?= h($_SESSION['user_name']) ?></span>
                        </a>
                        <ul class="dropdown-menu dropdown-menu-end dropdown-menu-arrow profile">
                            <li class="dropdown-header">
                                <h6><?= h($_SESSION['user_name']) ?></h6>
                                <span><?= ucfirst($_SESSION['user_role']) ?></span>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center" href="profile.php">
                                    <i class="fas fa-user"></i>
                                    <span>Profil</span>
                                </a>
                            </li>
                            <li><hr class="dropdown-divider"></li>
                            <li>
                                <a class="dropdown-item d-flex align-items-center" href="logout.php">
                                    <i class="fas fa-sign-out-alt"></i>
                                    <span>Çıkış</span>
                                </a>
                            </li>
                        </ul>
                    </li>
                </ul>
            </nav>
        </div>
    </header>

    <!-- NiceAdmin Main Content -->
    <main id="main" class="nice-main">
        <div class="pagetitle">
            <h1><?= $pageTitle ?? 'Admin Panel' ?></h1>
            <nav>
                <ol class="breadcrumb">
                    <li class="breadcrumb-item"><a href="dashboard.php">Ana Sayfa</a></li>
                    <?php if (isset($breadcrumbs) && is_array($breadcrumbs)): ?>
                        <?php foreach ($breadcrumbs as $crumb): ?>
                            <?php if (isset($crumb['url'])): ?>
                                <li class="breadcrumb-item"><a href="<?= $crumb['url'] ?>"><?= $crumb['title'] ?></a></li>
                            <?php else: ?>
                                <li class="breadcrumb-item active"><?= $crumb['title'] ?></li>
                            <?php endif; ?>
                        <?php endforeach; ?>
                    <?php else: ?>
                        <li class="breadcrumb-item active"><?= $pageTitle ?? 'Admin Panel' ?></li>
                    <?php endif; ?>
                </ol>
            </nav>
        </div>
