<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    echo json_encode(['success' => false, 'message' => 'Oturum geçersiz.']);
    exit;
}

try {
    $category_id = intval($_GET['category_id'] ?? 0);
    
    if ($category_id <= 0) {
        echo json_encode(['success' => false, 'message' => 'Geçersiz kategori ID.']);
        exit;
    }
    
    // Kategorideki ürünleri al
    $stmt = $pdo->prepare("
        SELECT p.id, p.name, p.description, p.type, p.price, p.is_active,
               pc.name as category_name
        FROM products p
        LEFT JOIN product_categories pc ON p.category_id = pc.id
        WHERE p.category_id = ? AND p.is_active = 1
        ORDER BY p.name ASC
    ");
    $stmt->execute([$category_id]);
    $products = $stmt->fetchAll();
    
    echo json_encode([
        'success' => true,
        'products' => $products,
        'count' => count($products)
    ]);
    
} catch (Exception $e) {
    error_log("Get products error: " . $e->getMessage());
    echo json_encode(['success' => false, 'message' => 'Ürünler yüklenirken hata oluştu.']);
}
?>
