<?php
session_start();
require_once '../config/config.php';
require_once '../includes/functions.php';

header('Content-Type: application/json');

if (!isLoggedIn()) {
    jsonResponse(['success' => false, 'message' => 'Yetkisiz erişim.'], 401);
}

if ($_SERVER['REQUEST_METHOD'] !== 'POST') {
    jsonResponse(['success' => false, 'message' => 'Geçersiz istek.'], 400);
}

$request_id = intval($_POST['request_id'] ?? 0);
$cancel_reason = trim($_POST['cancel_reason'] ?? '');

if (!$request_id) {
    jsonResponse(['success' => false, 'message' => 'Geçersiz başvuru ID.']);
}

try {
    $pdo->beginTransaction();
    
    // Başvuru durumunu kontrol et
    $stmt = $pdo->prepare("SELECT * FROM quote_requests WHERE id = ?");
    $stmt->execute([$request_id]);
    $request = $stmt->fetch();
    
    if (!$request) {
        throw new Exception('Başvuru bulunamadı.');
    }
    
    if ($request['status'] === 'CANCELLED') {
        throw new Exception('Bu başvuru zaten iptal edilmiş.');
    }
    
    // Başvuruyu iptal et
    $stmt = $pdo->prepare("
        UPDATE quote_requests 
        SET status = 'CANCELLED', 
            admin_notes = CONCAT(COALESCE(admin_notes, ''), '\n\n[İPTAL] ', NOW(), ' - ', ?)
        WHERE id = ?
    ");
    $stmt->execute([$cancel_reason, $request_id]);
    
    // Eğer teklif oluşturulmuşsa onu da iptal et
    $stmt = $pdo->prepare("SELECT id FROM quotes WHERE quote_request_id = ?");
    $stmt->execute([$request_id]);
    $quote = $stmt->fetch();
    
    if ($quote) {
        $stmt = $pdo->prepare("
            UPDATE quotes 
            SET internal_notes = CONCAT(COALESCE(internal_notes, ''), '\n\n[İPTAL] ', NOW(), ' - Başvuru iptal edildi.')
            WHERE quote_request_id = ?
        ");
        $stmt->execute([$request_id]);
    }
    
    // Audit log
    logAudit('quote_cancelled', 'quote_requests', $request_id, null, [
        'cancelled_by' => $_SESSION['user_id'],
        'cancel_reason' => $cancel_reason,
        'previous_status' => $request['status']
    ]);
    
    $pdo->commit();
    
    jsonResponse([
        'success' => true,
        'message' => 'Başvuru başarıyla iptal edildi.',
        'request_id' => $request_id
    ]);
    
} catch (Exception $e) {
    $pdo->rollBack();
    error_log("Cancel quote error: " . $e->getMessage());
    jsonResponse(['success' => false, 'message' => $e->getMessage()], 500);
}
?>
