<?php
session_start();
require_once 'config/config.php';
require_once 'includes/functions.php';
?>
<!DOCTYPE html>
<html lang="tr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Hakkımızda - Araç Bakım Servisi</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <link href="assets/css/style.css" rel="stylesheet">
</head>
<body>
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary">
        <div class="container">
            <a class="navbar-brand" href="index.php">
                <i class="fas fa-car"></i> Araç Bakım Servisi
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav ms-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="index.php">Ana Sayfa</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="about.php">Hakkımızda</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="contact.php">İletişim</a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link btn btn-warning text-dark px-3 ms-2" href="quote_form.php">
                            <i class="fas fa-clipboard-list"></i> Teklif Al
                        </a>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Hero Section -->
    <section class="hero-section">
        <div class="container">
            <div class="row align-items-center min-vh-75 pt-5">
                <div class="col-lg-6">
                    <div class="hero-content fade-in">
                        <h1 class="display-4 fw-bold text-white mb-4">
                            <span class="text-warning">15 Yıllık</span> Tecrübe ile<br>
                            Güvenilir Hizmet
                        </h1>
                        <p class="lead text-white-50 mb-4">
                            2009 yılından beri aracınızın bakım ve onarım ihtiyaçlarını karşılıyor, 
                            müşteri memnuniyetini ön planda tutuyoruz.
                        </p>
                    </div>
                </div>
                <div class="col-lg-6">
                    <div class="text-center">
                        <i class="fas fa-tools fa-10x text-warning opacity-75"></i>
                    </div>
                </div>
            </div>
        </div>
    </section>

    <div class="container mt-5">
        <!-- Hikayemiz -->
        <div class="row mb-5">
            <div class="col-lg-6">
                <div class="card shadow-lg h-100">
                    <div class="card-body p-4">
                        <h3 class="text-gradient mb-4">
                            <i class="fas fa-history text-primary"></i> Hikayemiz
                        </h3>
                        <p class="text-muted">
                            Araç Bakım Servisi, 2009 yılında küçük bir atölye olarak başladığı yolculuğunda, 
                            bugün İstanbul'un en güvenilir araç bakım merkezlerinden biri haline gelmiştir.
                        </p>
                        <p class="text-muted">
                            15 yıllık tecrübemizle, binlerce müşterimizin aracını güvenle teslim ettik. 
                            Kaliteli hizmet anlayışımız ve müşteri odaklı yaklaşımımızla sektörde 
                            fark yaratmaya devam ediyoruz.
                        </p>
                        <p class="text-muted">
                            Modern teknoloji ile geleneksel ustalığı birleştirerek, aracınızın 
                            ihtiyaç duyduğu her türlü bakım ve onarım hizmetini sunuyoruz.
                        </p>
                    </div>
                </div>
            </div>
            <div class="col-lg-6">
                <div class="card shadow-lg h-100">
                    <div class="card-body p-4">
                        <h3 class="text-gradient mb-4">
                            <i class="fas fa-eye text-success"></i> Vizyonumuz
                        </h3>
                        <p class="text-muted">
                            Türkiye'nin en güvenilir ve teknolojik araç bakım servisi olmak, 
                            müşterilerimize en kaliteli hizmeti sunarak sektörde lider konuma gelmek.
                        </p>
                        
                        <h5 class="text-gradient mt-4 mb-3">
                            <i class="fas fa-bullseye text-warning"></i> Misyonumuz
                        </h5>
                        <p class="text-muted">
                            Aracınızın güvenliğini ve performansını en üst düzeyde tutarak, 
                            size güvenli ve konforlu bir sürüş deneyimi sunmak. Şeffaf fiyatlandırma, 
                            kaliteli malzeme kullanımı ve uzman kadromuzla hizmet vermek.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Değerlerimiz -->
        <div class="row mb-5">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-gradient">Değerlerimiz</h2>
                <p class="lead text-muted">Hizmet anlayışımızı şekillendiren temel değerler</p>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg h-100 text-center">
                    <div class="card-body p-4">
                        <div class="value-icon mb-3">
                            <i class="fas fa-handshake fa-3x text-primary"></i>
                        </div>
                        <h5>Güvenilirlik</h5>
                        <p class="text-muted">
                            Sözümüzün arkasında durur, verdiğimiz garantileri eksiksiz yerine getiririz.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg h-100 text-center">
                    <div class="card-body p-4">
                        <div class="value-icon mb-3">
                            <i class="fas fa-medal fa-3x text-warning"></i>
                        </div>
                        <h5>Kalite</h5>
                        <p class="text-muted">
                            Sadece orijinal ve kaliteli yedek parçalar kullanır, işçiliğimizde asla taviz vermeyiz.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg h-100 text-center">
                    <div class="card-body p-4">
                        <div class="value-icon mb-3">
                            <i class="fas fa-eye fa-3x text-info"></i>
                        </div>
                        <h5>Şeffaflık</h5>
                        <p class="text-muted">
                            Fiyatlarımız nettir, gizli maliyet yoktur. Yapılan işlemleri detaylı şekilde açıklarız.
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg h-100 text-center">
                    <div class="card-body p-4">
                        <div class="value-icon mb-3">
                            <i class="fas fa-heart fa-3x text-danger"></i>
                        </div>
                        <h5>Müşteri Odaklılık</h5>
                        <p class="text-muted">
                            Müşteri memnuniyeti bizim için en önemli başarı kriteridir.
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- Ekibimiz -->
        <div class="row mb-5">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-gradient">Uzman Ekibimiz</h2>
                <p class="lead text-muted">Alanında uzman, sertifikalı teknisyenlerimiz</p>
            </div>
            
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card shadow-lg">
                    <div class="card-body text-center p-4">
                        <div class="team-avatar mb-3">
                            <i class="fas fa-user-tie fa-4x text-primary"></i>
                        </div>
                        <h5>Ahmet Yılmaz</h5>
                        <p class="text-muted mb-2">Baş Teknisyen</p>
                        <p class="small text-muted">
                            15 yıllık tecrübe ile motor ve şanzıman uzmanı. 
                            Mercedes, BMW ve Audi sertifikalı teknisyen.
                        </p>
                        <div class="team-skills">
                            <span class="badge bg-primary me-1">Motor Onarımı</span>
                            <span class="badge bg-success me-1">Şanzıman</span>
                            <span class="badge bg-info">Elektronik</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card shadow-lg">
                    <div class="card-body text-center p-4">
                        <div class="team-avatar mb-3">
                            <i class="fas fa-user-cog fa-4x text-success"></i>
                        </div>
                        <h5>Mehmet Demir</h5>
                        <p class="text-muted mb-2">Elektrik Uzmanı</p>
                        <p class="small text-muted">
                            12 yıllık tecrübe ile araç elektrik sistemleri uzmanı. 
                            Klima, airbag ve ABS sistemleri konusunda uzman.
                        </p>
                        <div class="team-skills">
                            <span class="badge bg-warning me-1">Elektrik</span>
                            <span class="badge bg-danger me-1">Klima</span>
                            <span class="badge bg-secondary">ABS</span>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 col-md-6 mb-4">
                <div class="card shadow-lg">
                    <div class="card-body text-center p-4">
                        <div class="team-avatar mb-3">
                            <i class="fas fa-user-check fa-4x text-warning"></i>
                        </div>
                        <h5>Ali Kaya</h5>
                        <p class="text-muted mb-2">Fren ve Süspansiyon Uzmanı</p>
                        <p class="small text-muted">
                            10 yıllık tecrübe ile fren sistemleri ve süspansiyon uzmanı. 
                            Lastik balans ve rot ayar konusunda sertifikalı.
                        </p>
                        <div class="team-skills">
                            <span class="badge bg-danger me-1">Fren Sistemi</span>
                            <span class="badge bg-info me-1">Süspansiyon</span>
                            <span class="badge bg-dark">Lastik</span>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Sertifikalar ve Ödüller -->
        <div class="row mb-5">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-gradient">Sertifikalar ve Ödüller</h2>
                <p class="lead text-muted">Kalitemizi belgeleyen sertifikalar</p>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg text-center">
                    <div class="card-body p-4">
                        <i class="fas fa-certificate fa-3x text-warning mb-3"></i>
                        <h6>ISO 9001:2015</h6>
                        <p class="small text-muted">Kalite Yönetim Sistemi Sertifikası</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg text-center">
                    <div class="card-body p-4">
                        <i class="fas fa-award fa-3x text-success mb-3"></i>
                        <h6>Müşteri Memnuniyeti</h6>
                        <p class="small text-muted">2023 Yılı En İyi Hizmet Ödülü</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg text-center">
                    <div class="card-body p-4">
                        <i class="fas fa-shield-alt fa-3x text-primary mb-3"></i>
                        <h6>Güvenlik Sertifikası</h6>
                        <p class="small text-muted">İş Güvenliği ve Çevre Sertifikası</p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-3 col-md-6 mb-4">
                <div class="card shadow-lg text-center">
                    <div class="card-body p-4">
                        <i class="fas fa-star fa-3x text-info mb-3"></i>
                        <h6>5 Yıldız</h6>
                        <p class="small text-muted">Google ve Yandex ortalama puanımız</p>
                    </div>
                </div>
            </div>
        </div>

        <!-- İstatistikler -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card shadow-lg bg-gradient text-white">
                    <div class="card-body p-5">
                        <div class="row text-center">
                            <div class="col-lg-3 col-md-6 mb-4">
                                <div class="stat-item">
                                    <h2 class="display-4 fw-bold text-warning">15+</h2>
                                    <p class="lead">Yıl Tecrübe</p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 mb-4">
                                <div class="stat-item">
                                    <h2 class="display-4 fw-bold text-warning">5000+</h2>
                                    <p class="lead">Mutlu Müşteri</p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 mb-4">
                                <div class="stat-item">
                                    <h2 class="display-4 fw-bold text-warning">15000+</h2>
                                    <p class="lead">Tamamlanan İş</p>
                                </div>
                            </div>
                            <div class="col-lg-3 col-md-6 mb-4">
                                <div class="stat-item">
                                    <h2 class="display-4 fw-bold text-warning">%98</h2>
                                    <p class="lead">Müşteri Memnuniyeti</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>

        <!-- Müşteri Yorumları -->
        <div class="row mb-5">
            <div class="col-12 text-center mb-5">
                <h2 class="display-5 fw-bold text-gradient">Müşteri Yorumları</h2>
                <p class="lead text-muted">Müşterilerimizin bizim hakkımızdaki düşünceleri</p>
            </div>
            
            <div class="col-lg-4 mb-4">
                <div class="card shadow-lg h-100">
                    <div class="card-body p-4">
                        <div class="d-flex mb-3">
                            <div class="me-3">
                                <div class="avatar-circle">MK</div>
                            </div>
                            <div>
                                <h6 class="mb-0">Mustafa Kaya</h6>
                                <small class="text-muted">BMW 3 Serisi Sahibi</small>
                            </div>
                        </div>
                        <div class="stars mb-3">
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                        </div>
                        <p class="text-muted">
                            "3 yıldır aracımın bakımını burada yaptırıyorum. Hem fiyatları uygun, 
                            hem de işlerini çok titiz yapıyorlar. Kesinlikle tavsiye ederim."
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 mb-4">
                <div class="card shadow-lg h-100">
                    <div class="card-body p-4">
                        <div class="d-flex mb-3">
                            <div class="me-3">
                                <div class="avatar-circle">AY</div>
                            </div>
                            <div>
                                <h6 class="mb-0">Ayşe Yıldız</h6>
                                <small class="text-muted">Mercedes C180 Sahibi</small>
                            </div>
                        </div>
                        <div class="stars mb-3">
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                        </div>
                        <p class="text-muted">
                            "Aracımda elektrik arızası vardı, başka yerlerde çözemedikleri sorunu 
                            burada kısa sürede hallettiler. Çok memnun kaldım."
                        </p>
                    </div>
                </div>
            </div>
            
            <div class="col-lg-4 mb-4">
                <div class="card shadow-lg h-100">
                    <div class="card-body p-4">
                        <div class="d-flex mb-3">
                            <div class="me-3">
                                <div class="avatar-circle">HT</div>
                            </div>
                            <div>
                                <h6 class="mb-0">Hasan Tunç</h6>
                                <small class="text-muted">Ford Focus Sahibi</small>
                            </div>
                        </div>
                        <div class="stars mb-3">
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                            <i class="fas fa-star text-warning"></i>
                        </div>
                        <p class="text-muted">
                            "Online teklif sistemi çok pratik. Evden çıkmadan teklif aldım, 
                            fiyat da çok uygundu. Hizmet kalitesi de mükemmel."
                        </p>
                    </div>
                </div>
            </div>
        </div>

        <!-- CTA Section -->
        <div class="row mb-5">
            <div class="col-12">
                <div class="card shadow-lg bg-primary text-white">
                    <div class="card-body text-center p-5">
                        <h3 class="mb-4">Aracınız İçin Hemen Teklif Alın!</h3>
                        <p class="lead mb-4">
                            15 yıllık tecrübemizle aracınızın ihtiyaçlarını belirleyip, 
                            size en uygun teklifi sunuyoruz.
                        </p>
                        <a href="quote_form.php" class="btn btn-warning btn-lg">
                            <i class="fas fa-clipboard-list"></i> Ücretsiz Teklif Al
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Footer -->
    <footer class="bg-dark text-white py-4">
        <div class="container">
            <div class="row align-items-center">
                <div class="col-md-6">
                    <div class="d-flex align-items-center">
                        <i class="fas fa-car fa-2x text-warning me-3"></i>
                        <div>
                            <h6 class="mb-0">Araç Bakım Servisi</h6>
                            <small>Profesyonel araç bakım hizmetleri</small>
                        </div>
                    </div>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; 2024 Araç Bakım Servisi. Tüm hakları saklıdır.</p>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script src="assets/js/main.js"></script>
    <script>
        // Sayfa yüklendiğinde animasyonlar
        document.addEventListener('DOMContentLoaded', function() {
            // Kartları sırayla göster
            const cards = document.querySelectorAll('.card');
            cards.forEach((card, index) => {
                card.style.opacity = '0';
                card.style.transform = 'translateY(30px)';
                
                setTimeout(() => {
                    card.style.transition = 'all 0.6s ease';
                    card.style.opacity = '1';
                    card.style.transform = 'translateY(0)';
                }, index * 100);
            });

            // İstatistikleri animasyonlu göster
            const stats = document.querySelectorAll('.stat-item h2');
            const observer = new IntersectionObserver((entries) => {
                entries.forEach(entry => {
                    if (entry.isIntersecting) {
                        const target = entry.target;
                        const finalValue = target.textContent;
                        let currentValue = 0;
                        const increment = finalValue.includes('+') ? 
                            parseInt(finalValue.replace(/\D/g, '')) / 50 : 
                            parseInt(finalValue.replace(/\D/g, '')) / 50;
                        
                        const timer = setInterval(() => {
                            currentValue += increment;
                            if (currentValue >= parseInt(finalValue.replace(/\D/g, ''))) {
                                target.textContent = finalValue;
                                clearInterval(timer);
                            } else {
                                target.textContent = Math.floor(currentValue) + (finalValue.includes('+') ? '+' : finalValue.includes('%') ? '%' : '');
                            }
                        }, 50);
                    }
                });
            });

            stats.forEach(stat => observer.observe(stat));
        });
    </script>

    <style>
        .min-vh-75 {
            min-height: 75vh;
        }
        
        .value-icon {
            transition: transform 0.3s ease;
        }
        
        .card:hover .value-icon {
            transform: scale(1.1);
        }
        
        .team-avatar {
            transition: transform 0.3s ease;
        }
        
        .card:hover .team-avatar {
            transform: scale(1.1);
        }
        
        .team-skills .badge {
            font-size: 0.7rem;
        }
        
        .avatar-circle {
            width: 50px;
            height: 50px;
            border-radius: 50%;
            background: linear-gradient(135deg, var(--primary-color) 0%, var(--primary-dark) 100%);
            color: white;
            display: flex;
            align-items: center;
            justify-content: center;
            font-weight: bold;
        }
        
        .stars i {
            font-size: 0.9rem;
        }
        
        .stat-item {
            transition: transform 0.3s ease;
        }
        
        .stat-item:hover {
            transform: scale(1.05);
        }
    </style>
</body>
</html>
